# 📱 راهنمای استفاده از JSON وب‌اپ eSIM (نسخه 2.0)

این فایل راهنمای استفاده از فایل `home.json` برای وب‌اپ فروشگاه eSIM است.

## 🆕 تغییرات نسخه 2.0

### ✅ انجام شده:
- ✅ **عکس‌های هدر جایگزین شد**: از ایموجی (👤 🔍) به جای لینک عکس استفاده شد
- ✅ **بخش "eSIM چیست" و "مزایا" حذف شد**: صفحه ساده‌تر و فوکوس بیشتر
- ✅ **اسلایدر بهبود یافت**: از Placehold.co به جای Placeholder استفاده شد
- ✅ **3 بخش جدید اضافه شد**:
  - 🌍 کشورهای محبوب (6 کشور)
  - 🔥 پیشنهادات ویژه (2 بسته با قیمت و دکمه خرید)
  - 📦 بسته‌های محبوب (3 منطقه: اروپا، آسیا، آمریکا)

---

## 📍 مسیر فایل

```
/api/home.json
```

**تعداد Wrappers**: 2  
**تعداد Sections**: 6  
**حجم فایل**: ~16 KB

---

## 🔗 لینک‌های استفاده شده

### صفحات اصلی:
- **صفحه اصلی (لیست کشورها)**: `https://esim.matinacard.com/`
- **صفحه کشور**: `https://esim.matinacard.com/country.php?code=TR`
- **داشبورد کاربر**: `https://esim.matinacard.com/dashboard.php`
- **eSIM های من**: `https://esim.matinacard.com/my-esims.php`
- **خرید**: `https://esim.matinacard.com/checkout.php`

### کدهای کشورها:
| کشور | کد ISO | لینک |
|------|--------|------|
| ترکیه | TR | `/country.php?code=TR` |
| امارات | AE | `/country.php?code=AE` |
| آلمان | DE | `/country.php?code=DE` |
| فرانسه | FR | `/country.php?code=FR` |
| انگلستان | GB | `/country.php?code=GB` |
| آمریکا | US | `/country.php?code=US` |
| کانادا | CA | `/country.php?code=CA` |
| استرالیا | AU | `/country.php?code=AU` |

---

## 🏳️ پرچم کشورها (FlagCDN)

برای نمایش پرچم کشورها از این URL استفاده می‌شود:

```
https://flagcdn.com/w320/{country-code}.png
```

**مثال:**
- ترکیه: `https://flagcdn.com/w320/tr.png`
- امارات: `https://flagcdn.com/w320/ae.png`
- آلمان: `https://flagcdn.com/w320/de.png`

---

## 🎨 رنگ‌های اصلی

```css
/* رنگ اصلی قرمز eSIM */
primary: rgb(203, 25, 25)
secondary: rgb(255, 41, 41)

/* رنگ متن */
text-dark: rgb(51, 51, 51)
text-gray: rgb(128, 128, 128)

/* رنگ پس‌زمینه */
bg-light: rgb(246, 246, 246)
bg-white: rgb(255, 255, 255)
```

---

## 📦 ساختار JSON

فایل JSON شامل موارد زیر است:

### 1. **Wraper اول - Header + Slider**
- **Header**: شامل آیکون پروفایل، عنوان "فروشگاه eSIM"، آیکون جستجو
- **Slider**: 3 بنر تبلیغاتی با autoplay

### 2. **Wraper دوم - محتوای اصلی**
- **دکمه اصلی**: "مشاهده تمام کشورها و پلن‌ها"
- **کشورهای محبوب**: 8 کشور با پرچم و لینک
- **بخش اطلاعات**: توضیح eSIM و مزایا

---

## ✏️ نحوه تغییر لینک‌ها

اگر می‌خواهید لینک کشوری را تغییر دهید:

```json
{
  "row_type": "banner",
  "image": "https://flagcdn.com/w320/tr.png",
  "options": {
    "description": "ترکیه",
    "outLink": "https://esim.matinacard.com/country.php?code=TR"
  }
}
```

فقط `outLink` را تغییر دهید:
```json
"outLink": "https://DOMAIN.com/country.php?code=TR"
```

---

## 🔄 افزودن کشور جدید

برای افزودن کشور جدید، یک آیتم بنر جدید اضافه کنید:

```json
{
  "row_type": "banner",
  "id": "",
  "type": "out_link",
  "link": "",
  "image": "https://flagcdn.com/w320/es.png",
  "size": "one-fourth",
  "options": {
    "customClass": "item-box",
    "borderSize": 0,
    "borderRadius": 10,
    "width": "80",
    "alignSelf": "center",
    "showBannerDescription": true,
    "description": "اسپانیا",
    "descriptionFontSize": "12",
    "outLink": "https://esim.matinacard.com/country.php?code=ES"
  }
}
```

---

## 📸 تغییر بنرهای اسلایدر

برای تغییر بنرها:

```json
{
  "row_type": "sliderItem",
  "type": "out_link",
  "id": 1,
  "image": "URL_تصویر_جدید",
  "link": "https://esim.matinacard.com/"
}
```

**توجه:** بنرها باید سایز `800x400` یا نسبت `2:1` داشته باشند.

---

## 🧪 تست JSON

برای تست JSON:

1. فایل را در وب‌اپ خود لود کنید
2. بررسی کنید که تمام تصاویر پرچم‌ها نمایش داده می‌شوند
3. روی هر کشور کلیک کنید و بررسی کنید که به صفحه درست می‌رود
4. بنرهای اسلایدر را چک کنید

---

## 🌐 دامنه خود را تغییر دهید

برای تغییر دامنه، با Find & Replace تمام `https://esim.matinacard.com` را جایگزین کنید:

```
جایگزینی: https://esim.matinacard.com
با: https://YOUR-DOMAIN.com
```

---

## 💡 نکات مهم

1. ✅ تمام لینک‌ها باید با `https://` شروع شوند
2. ✅ کدهای کشور باید 2 حرفی ISO باشند (مثل TR، AE، DE)
3. ✅ پرچم‌ها از FlagCDN بارگذاری می‌شوند (نیازی به آپلود نیست)
4. ✅ JSON باید Valid باشد (از JSONLint.com چک کنید)
5. ✅ ساختار JSON را تغییر ندهید، فقط محتوا را تغییر دهید

---

## 🆘 پشتیبانی

اگر سوالی دارید یا نیاز به کمک دارید، با تیم فنی تماس بگیرید.

---

✨ **موفق باشید!**

